import pandas as pd   
import pickle
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv")   
  
credit_customers['credit_amount_range'] = pd.cut(credit_customers['credit_amount'], bins=[0, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000], include_lowest=True)   

approval_rates_credit_amount = credit_customers.groupby('credit_amount_range')['class'].value_counts(normalize=True).unstack().fillna(0)['good'] 

print(approval_rates_credit_amount)
pickle.dump(approval_rates_credit_amount,open("./ref_result/approval_rates_credit_amount.pkl","wb"))

  